/**
 * 
 */
package be.SIRAPRISE.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

/**
 * @author Erwin
 * 
 */
public class CRLFInputStream extends InputStream {

	/**
	 * 
	 */
	private static final byte CR = 0x0D;

	/**
	 * 
	 */
	private static final byte LF = 0x0A;

	/**
	 * 
	 */
	private InputStream in;

	/**
	 * 
	 */
	private boolean skipByteIfLF;

	/**
	 * Creates the CRLFInputStream
	 * 
	 * @param in
	 *            The input stream underlying this input stream
	 */
	public CRLFInputStream (InputStream in) {
		this.in = in;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.InputStream#read()
	 */
	@Override
	public int read ( ) throws IOException {
		return in.read();
	}

	/**
	 * @param charSet
	 *            the charset used to encode when writing the file
	 * @return The line read
	 * @throws IOException
	 */
	public String readLine (Charset charSet) throws IOException {
		int capacity = 2048;
		byte[] buffer = new byte[capacity];
		boolean proceed = true;
		boolean anyByteRead = false;
		int byteCount = 0;

		while (proceed) {
			byte b = (byte) in.read();
			switch (b) {
				case -1: {
					// EOF reached
					proceed = false;
					break;
				}
				case CR: {
					proceed = false;
					anyByteRead = true;
					skipByteIfLF = true;
					break;
				}
				case LF: {
					if (!skipByteIfLF) {
						proceed = false;
						anyByteRead = true;
					}
					skipByteIfLF = false;
					break;
				}
				default: {
					skipByteIfLF = false;
					anyByteRead = true;
					if (byteCount == capacity) {
						if ((capacity & 0x40000000) == 0) {
							capacity <<= 1;
							byte[] newbuffer = new byte[capacity];
							System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
							buffer = newbuffer;
						} else {
							throw new OutOfMemoryError();
						}
					}
					buffer[byteCount] = b;
					byteCount++;
				}
			}
		}

		if (!anyByteRead) {
			throw new EOFException();
		}

		return new String(buffer, 0, byteCount, charSet);
	}
}
