/*
 * Created on 25-apr-2007
 */
package be.SIRAPRISE.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author Erwin Smout
 */
public class DataInputStreamWithByteCounter extends DataInputStream {

	/**
	 * 
	 */
	private long byteCounter = 0;

	/**
	 * Creates the DataInputStreamWithByteCounter
	 * 
	 * @param in
	 */
	public DataInputStreamWithByteCounter (InputStream in) {
		super(in);
	}

	/**
	 * Gets byteCounter
	 * 
	 * @return byteCounter.
	 */
	public final long getByteCounter ( ) {
		return byteCounter;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterInputStream#read()
	 */
	@Override
	public int read ( ) throws IOException {
		byteCounter++;
		return super.read();
	}
}