/*
 * Created on 26-nov-03
 */
package be.SIRAPRISE.util;

/**
 * @author Erwin
 */
public final class FixedLengthFormatter {
	/**
	 *
	 */
	private static StringBuffer psb = new StringBuffer("                                                                                                                                                                                                                                                                "); //$NON-NLS-1$

	/**
	 *
	 */
	private static StringBuffer psn = new StringBuffer("000000000000000000"); //$NON-NLS-1$

	/**
	 * Prepends a specified number of blanks to a String
	 * 
	 * @param length
	 *            The number of blanks to prepend
	 * @param buffer
	 *            The buffer where blanks have to be prepended
	 * @return the input string padded with blanks
	 */
	public static String prependBlanks (int length, String buffer) {
		return psb.substring(0, length) + buffer;
	}

	/**
	 * Appends blanks to a String such that the string length becomes equal to a given length
	 * 
	 * @param length
	 *            The length that the string has to become
	 * @param buffer
	 *            The string value to which blanks have to be appended
	 * @return the input string padded with blanks
	 */
	public static String appendBlanks (int length, String buffer) {
		String out;
		if (buffer.length() > length) {
			out = buffer.substring(0, length);
		} else {
			out = buffer;
		}

		int padLength = length - buffer.length(), padPartLength;

		while (padLength > 0) {
			if (padLength > psb.length()) {
				padPartLength = psb.length();
			} else {
				padPartLength = padLength;
			}
			out = out + psb.substring(0, padPartLength);
			padLength -= padPartLength;
		}
		return out;
	}

	/**
	 * @param length
	 * @param buffer
	 */
	public static void appendBlanks (int length, StringBuffer buffer) {
		if (buffer.length() > length) {
			buffer.setLength(length);
		}

		int padLength = length - buffer.length(), padPartLength;

		while (padLength > 0) {
			if (padLength > psb.length()) {
				padPartLength = psb.length();
			} else {
				padPartLength = padLength;
			}
			buffer.append(psb.substring(0, padPartLength));
			padLength -= padPartLength;
		}
	}

	/**
	 * @param length
	 *            the total length that the number must have after formatting
	 * @param buffer
	 *            the number to be formatted
	 * @return the input string prepended with zeroes
	 */
	public static String prependZeroes (int length, String buffer) {
		String out;
		if (buffer.charAt(0) == '-') {
			out = psn + buffer.substring(1);
			out = '-' + out.substring(out.length() - (length - 1));
		} else {
			out = psn + buffer;
			out = out.substring(out.length() - length);
		}
		return out;
	}

	/**
	 * @param length
	 *            the total length that the number must have after formatting
	 * @param buffer
	 *            the number to be formatted
	 */
	public static void prependZeroes (int length, StringBuffer buffer) {
		buffer.insert(0, psn);
		buffer.delete(0, buffer.length() - length);
	}

	/**
	 * 
	 */
	private FixedLengthFormatter ( ) {

	}

	/**
	 * @param length
	 *            the total length that the number must have after formatting
	 * @param buffer
	 *            the number to be formatted
	 */
	public static void appendZeroes (int length, StringBuffer buffer) {
		while (buffer.length() < length) {
			buffer.append(psn.substring(0, Math.min(psn.length(), length - buffer.length())));
		}
	}
}
