/*
 * Created on 16-aug-04
 */
package be.SIRAPRISE.util;

import java.nio.ByteBuffer;

/**
 * @author Erwin Smout
 */
public class Hasher {

	/**
	 * The hash modulo number
	 */
	static final int HASHMOD = 23878069;

	/**
	 * @param bb
	 * @return the hash
	 */
	public static int hash (ByteBuffer bb) {
		long v = 1, wv;
		bb.rewind();
		while (bb.remaining() > 3) {
			wv = bb.getInt();
			if (wv <= 0) {
				wv += 2 * ((long) Integer.MAX_VALUE + 1);
			}
			v = (v * v) % HASHMOD;
			v = (v * (wv % HASHMOD)) % HASHMOD;
		}
		if (bb.remaining() > 1) {
			wv = bb.getShort();
			if (wv <= 0) {
				wv += 2 * ((long) Integer.MAX_VALUE + 1);
			}
			v = (v * v) % HASHMOD;
			v = (v * (wv % HASHMOD)) % HASHMOD;
		}
		if (bb.remaining() > 0) {
			wv = bb.get();
			if (wv <= 0) {
				wv += 2 * ((long) Integer.MAX_VALUE + 1);
			}
			v = (v * v) % HASHMOD;
			v = (v * (wv % HASHMOD)) % HASHMOD;
		}
		return (int) v;
	}
}