/*
 * Created on 2-nov-2005
 */
package be.SIRAPRISE.util;

import java.util.*;

import be.SIRAPRISE.util.IntersectableMap;

/**
 * IntersectableHashMap is an extension of HashMap that has definitions for union, intersection and difference of maps, definitions that are loosely based on the definitions of those operators of set theory.
 * 
 * @author Erwin Smout
 * @param <K>
 * @param <V>
 */
public class IntersectableHashMap<K, V> extends IntersectableMap<K, V> {

	/**
	 * provides the link to the HashMap method implementations
	 */
	private HashMap<K, V> map;

	/**
	 * Initializes a DbmsHashMap of the default size
	 */
	public IntersectableHashMap ( ) {
		map = new HashMap<K, V>();
	}

	/**
	 * Initializes a DbmsHashMap with an initial size that is given
	 * 
	 * @param q
	 *            the initial size of the map
	 */
	public IntersectableHashMap (int q) {
		map = new HashMap<K, V>(q);
	}

	/**
	 * Initializes a DbmsHashMap with an initial size that is given
	 * 
	 * @param q
	 *            the initial size of the map
	 * @param loadFactor
	 *            the load factor to be used
	 */
	public IntersectableHashMap (int q, float loadFactor) {
		map = new HashMap<K, V>(q, loadFactor);
	}

	/**
	 * Initializes a DbmsHashMap with an initial size that is given
	 * 
	 * @param m
	 *            The map whose mappings are to be copied into the new map
	 */
	public IntersectableHashMap (Map<? extends K, ? extends V> m) {
		map = new HashMap<K, V>(m);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMap()
	 */
	Map<K, V> getMap ( ) {
		return map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMapClone()
	 */
	@SuppressWarnings("unchecked")
	Map<K, V> getMapClone ( ) {
		return (Map<K, V>) map.clone();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#setMap(java.util.Map)
	 */
	void setMap (Map<K, V> map) {
		this.map = (HashMap<K, V>) map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.util.IntersectableMap#getClone()
	 */
	@Override
	protected IntersectableMap<K, V> getClone ( ) {
		return new IntersectableHashMap<K, V>(this);
	}
}