/*
 * Created on 2-nov-2005
 */
package be.SIRAPRISE.util;

import java.util.*;

import be.SIRAPRISE.util.IntersectableMap;

/**
 * IntersectableLinkedHashMap is an extension of IntersectableMap that exposes the behaviour of a LinkedHashMap.
 * 
 * @author Erwin Smout
 * @param <K>
 * @param <V>
 */
public class IntersectableLinkedHashMap<K, V> extends IntersectableMap<K, V> {

	/**
	 * provides the link to the LinkedHashMap method implementations
	 */
	private LinkedHashMap<K, V> map;

	/**
	 * Initializes a LinkedHashMap of the default size
	 */
	public IntersectableLinkedHashMap ( ) {
		map = new LinkedHashMap<K, V>();
	}

	/**
	 * Initializes a LinkedHashMap with an initial size that is given
	 * 
	 * @param q
	 *            the initial size of the map
	 */
	public IntersectableLinkedHashMap (int q) {
		map = new LinkedHashMap<K, V>(q);
	}

	/**
	 * Initializes a LinkedHashMap with an initial size that is given
	 * 
	 * @param q
	 *            the initial size of the map
	 * @param loadFactor
	 *            the load factor.
	 */
	public IntersectableLinkedHashMap (int q, float loadFactor) {
		map = new LinkedHashMap<K, V>(q, loadFactor);
	}

	/**
	 * Initializes a LinkedHashMap with an initial size that is given
	 * 
	 * @param q
	 *            the initial size of the map
	 * @param loadFactor
	 *            the load factor.
	 * @param accessOrder
	 *            the ordering mode - <tt>true</tt> for access-order, <tt>false</tt> for insertion-order.
	 */
	public IntersectableLinkedHashMap (int q, float loadFactor, boolean accessOrder) {
		map = new LinkedHashMap<K, V>(q, loadFactor, accessOrder);
	}

	/**
	 * Initializes a LinkedHashMap with an initial size that is given
	 * 
	 * @param m
	 */
	public IntersectableLinkedHashMap (Map<? extends K, ? extends V> m) {
		map = new LinkedHashMap<K, V>(m);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMap()
	 */
	Map<K, V> getMap ( ) {
		return map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMapClone()
	 */
	@SuppressWarnings("unchecked")
	Map<K, V> getMapClone ( ) {
		return (Map<K, V>) map.clone();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#setMap(java.util.Map)
	 */
	void setMap (Map<K, V> map) {
		this.map = (LinkedHashMap<K, V>) map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.util.IntersectableMap#getClone()
	 */
	@Override
	protected IntersectableMap<K, V> getClone ( ) {
		return new IntersectableLinkedHashMap<K, V>(this);
	}
}
