/*
 * Created on 2-nov-2005
 */
package be.SIRAPRISE.util;

import java.util.*;

import be.SIRAPRISE.util.IntersectableMap;

/**
 * IntersectableHashMap is an extension of IntersectableMap that has a TreeMap as its underlying map type
 * 
 * @author Erwin Smout
 * @param <K>
 * @param <V>
 */
public class IntersectableTreeMap<K, V> extends IntersectableMap<K, V> implements SortedMap<K, V> {

	/**
	 * provides the link to the TreeMap method implementations
	 */
	private TreeMap<K, V> map;

	/**
	 * Initializes a new IntersectableTreeMap
	 */
	public IntersectableTreeMap ( ) {
		map = new TreeMap<K, V>();
	}

	/**
	 * Initializes a IntersectableTreeMap
	 * 
	 * @param c
	 */
	public IntersectableTreeMap (Comparator<? super K> c) {
		map = new TreeMap<K, V>(c);
	}

	/**
	 * Initializes a IntersectableTreeMap
	 * 
	 * @param m
	 */
	public IntersectableTreeMap (Map<? extends K, ? extends V> m) {
		map = new TreeMap<K, V>(m);
	}

	/**
	 * Initializes a IntersectableTreeMap
	 * 
	 * @param m
	 */
	public IntersectableTreeMap (SortedMap<? extends K, ? extends V> m) {
		map = new TreeMap<K, V>(m);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMap()
	 */
	Map<K, V> getMap ( ) {
		return map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#getMapClone()
	 */
	@SuppressWarnings("unchecked")
	Map<K, V> getMapClone ( ) {
		return (Map<K, V>) map.clone();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.util.IntersectableMap#setMap(java.util.Map)
	 */
	void setMap (Map<K, V> map) {
		this.map = (TreeMap<K, V>) map;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#comparator()
	 */
	public Comparator<? super K> comparator ( ) {
		return map.comparator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#firstKey()
	 */
	public K firstKey ( ) {
		return map.firstKey();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#headMap(java.lang.Object)
	 */
	public SortedMap<K, V> headMap (K toKey) {
		return map.headMap(toKey);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#lastKey()
	 */
	public K lastKey ( ) {
		return map.lastKey();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#subMap(java.lang.Object, java.lang.Object)
	 */
	public SortedMap<K, V> subMap (K fromKey, K toKey) {
		return map.subMap(fromKey, toKey);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.SortedMap#tailMap(java.lang.Object)
	 */
	public SortedMap<K, V> tailMap (K fromKey) {
		return map.tailMap(fromKey);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.util.IntersectableMap#getClone()
	 */
	@Override
	protected IntersectableMap<K, V> getClone ( ) {
		return new IntersectableTreeMap<K, V>(this);
	}
}
