/**
 * 
 */
package be.SIRAPRISE.util;

import java.math.BigInteger;

/**
 * @author Erwin
 * 
 */
public abstract class MyBigInteger {

	/**
	 * 
	 */
	private static final char[] chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-".toCharArray(); //$NON-NLS-1$

	/**
	 * 
	 */
	private static final char[] reverseChars = initReverseChars();

	/**
	 * @return
	 */
	private static char[] initReverseChars ( ) {
		char[] wReverseChars = new char[96];
		for (int i = 0; i < chars.length; i++) {
			// System.out.println("char = "+chars[i]);
			// System.out.println("index = "+(chars[i]-32));
			// System.out.println("value = "+i);
			wReverseChars[chars[i] - 32] = (char) i;
		}

		return wReverseChars;
	}

	/**
	 * Gets a BigInteger from a radix 64 representation created by toString()
	 * 
	 * @param s
	 *            the radix 64 representation of a BigInteger
	 * @return a BigInteger from a radix 64 representation created by toString()
	 */
	public static BigInteger getBigInteger (String s) {
		char[] digits64 = s.toCharArray();
		BigInteger wbi = BigInteger.ZERO;
		for (int ix = 0; ix < digits64.length; ix++) {
			wbi = wbi.shiftLeft(6).add(BigInteger.valueOf(reverseChars[digits64[ix] - 32]));
		}
		return wbi;
	}

	/**
	 * Gets a radix 64 representation of i
	 * 
	 * @param i
	 *            the number to be represented in radix 64
	 * @return a radix 64 representation of i
	 */
	public static String toString (BigInteger i) {
		if (i.signum() == 0) {
			return "0"; //$NON-NLS-1$
		}

		// Translate number to string, a digit group at a time
		BigInteger tmp = i.abs();
		char digits64[] = new char[(tmp.bitLength() - 1) / 6 + 1];
		int ix = digits64.length - 1;
		while (ix >= 0) {
			long w2 = 0x0fffffffffffffffL;
			long w = tmp.longValue() & 0x0fffffffffffffffL;
			tmp = tmp.shiftRight(60);

			while (w2 > 0 && ix >= 0) {
				digits64[ix--] = chars[(int) (w & 0x000000000000003fL)];
				w >>= 6;
				w2 >>= 6;
			}

			// ix--;
		}

		// Put sign (if any) and first digit group into result buffer
		StringBuilder buf = new StringBuilder(digits64.length + 1);
		if (i.signum() < 0) {
			buf.append('-');
		}
		buf.append(new String(digits64));
		return buf.toString();
	}
}
