/*
 * Created on 25-feb-2006
 */
package be.SIRAPRISE.util;

import java.nio.ByteBuffer;

/**
 * Class to dump the contents of a ByteBuffer in hex
 * 
 * @author Erwin Smout
 */
public class MyByteBuffer {

	/**
	 * The hexadecimal output characters
	 */
	private static char[] hexchars = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

	/**
	 * Returns true if two byte buffers have equal limits, plus equal bytes in all buffer positions before the limit
	 * 
	 * @param buffer1
	 *            The first buffer to be compared
	 * @param buffer2
	 *            The secondbuffer to be compared
	 * @return true if two byte buffers have equal limits, plus equal bytes in all buffer positions before the limit
	 */
	public static boolean equalBytes (ByteBuffer buffer1, ByteBuffer buffer2) {
		if (buffer1.limit() != buffer2.limit()) {
			return false;
		}

		boolean result = true;
		int pos1 = buffer1.position();
		int pos2 = buffer2.position();
		buffer1.rewind();
		buffer2.rewind();

		while (buffer1.remaining() > 7 && result) {
			if (buffer1.getLong() != buffer2.getLong()) {
				result = false;
			}
		}
		if (buffer1.remaining() > 3 && result) {
			if (buffer1.getInt() != buffer2.getInt()) {
				result = false;
			}
		}
		while (buffer1.remaining() > 0 && result) {
			if (buffer1.get() != buffer2.get()) {
				result = false;
			}
		}

		buffer1.position(pos1);
		buffer2.position(pos2);

		return result;
	}

	/**
	 * Builds a hexadecimal representation of the contents of any ByteBuffer
	 * 
	 * @param byteBuffer
	 *            The bytebuffer
	 * @return the contents of the bytebuffer represented in hex
	 */
	public static String toHex (ByteBuffer byteBuffer) {
		try {
			byte[] bytes = byteBuffer.array();
			StringBuilder hex = new StringBuilder(2 * (byteBuffer.limit()));
			int c = byteBuffer.arrayOffset(), l = byteBuffer.limit() + c, i1, i2;
			while (c < l) {
				// i1 = new Byte(b[c++]).intValue();
				i1 = bytes[c++];
				if (i1 < 0) {
					i1 = 2 * (Byte.MAX_VALUE + 1) + i1;
				}
				i2 = i1 % 16;
				i1 = i1 / 16;
				hex.append(hexchars[i1]).append(hexchars[i2]);
			}
			return hex.toString();
		} catch (RuntimeException e) {
			int position = byteBuffer.position();
			byteBuffer.rewind();
			StringBuilder hex = new StringBuilder(2 * (byteBuffer.limit()));
			while (byteBuffer.remaining() > 0) {
				int i1 = byteBuffer.get();
				if (i1 < 0) {
					i1 = 2 * (Byte.MAX_VALUE + 1) + i1;
				}
				int i2 = i1 % 16;
				i1 = i1 / 16;
				hex.append(hexchars[i1]).append(hexchars[i2]);
			}
			byteBuffer.position(position);
			return hex.toString();
		}
	}
}
