/**
 * 
 */
package be.SIRAPRISE.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

/**
 * @author Erwin
 * 
 */
public class MyCipherInputStream extends FilterInputStream {

	/**
	 * 
	 */
	private int currentOffset = -1;

	/**
	 * 
	 */
	private byte[] decryptedBuffer;

	/**
	 * 
	 */
	private BigInteger decryptExponent;

	/**
	 * 
	 */
	private BigInteger modulus;

	/**
	 * Creates the InputStream
	 * 
	 * @param inputStream
	 * @param decryptExponent
	 *            The exponent using which the decryption is to be done
	 * @param modulus
	 *            The modulus using which the decryption is to be done
	 */
	public MyCipherInputStream (InputStream inputStream, BigInteger decryptExponent, BigInteger modulus) {
		super(inputStream);
		this.decryptExponent = decryptExponent;
		this.modulus = modulus;
	}

	/**
	 * Get a block of data from the input stream into the 'encrypted' buffer
	 * 
	 * @throws IOException
	 *             If an IO exception occurs on the input stream, or if no full block of data could be read
	 * @throws be.erwinsmout.NotFoundException
	 *             if no more data is present in the input stream
	 * 
	 */
	private void getChunk ( ) throws IOException, be.erwinsmout.NotFoundException {
		int originalInputLength1 = in.read();
		if (originalInputLength1 < 0) {
			throw new be.erwinsmout.NotFoundException();
		}
		int originalInputLength2 = in.read();
		int originalInputLength3 = in.read();
		int originalInputLength4 = in.read();
		if (originalInputLength2 < 0 || originalInputLength3 < 0 || originalInputLength4 < 0) {
			throw new IOException();
		}

		int originalInputLength = (originalInputLength1 << 24) + (originalInputLength2 << 16) + (originalInputLength3 << 8) + originalInputLength4;
		boolean swapSign = false;
		if (originalInputLength < 0) {
			swapSign = true;
			originalInputLength = -originalInputLength;
		}
		decryptedBuffer = new byte[originalInputLength];

		int length1 = in.read();
		// if (length1 < 0) {
		// throw new be.erwinsmout.NotFoundException();
		// }
		int length2 = in.read();
		int length3 = in.read();
		int length4 = in.read();
		if (length1 < 0 || length2 < 0 || length3 < 0 || length4 < 0) {
			throw new IOException();
		}
		int encryptedlength = (length1 << 24) + (length2 << 16) + (length3 << 8) + length4;
		if (modulus.compareTo(BigInteger.valueOf(2).pow(8 * encryptedlength)) >= 0) {
			throw new IOException();
		}
		byte[] encryptedBuffer = new byte[encryptedlength];
		int byteCount = in.read(encryptedBuffer);
		if (byteCount < encryptedBuffer.length) {
			throw new IOException();
		}

//		System.out.println("  Decryptor with modulus " + modulus.toString(16));
//		System.out.println("    original written block length is " + decryptedBuffer.length);
//		System.out.println("    encrypted block length is " + encryptedlength);
//		System.out.println("    encrypted data is " + Arrays.toString(encryptedBuffer));

		byte[] shortDecryptedBuffer = new BigInteger(encryptedBuffer).modPow(decryptExponent, modulus).toByteArray();

//		System.out.println("    decrypted block length is " + shortDecryptedBuffer.length);
//		System.out.println("    decrypted data is " + Arrays.toString(shortDecryptedBuffer));

		if (swapSign) {
			//Since the sign was swapped on encrypting, this means the original number was negative (e.g. 0x8ddddd to 0xfdddddd), made positive (adding a 00 byte in front of it, increasing the original length by 1).
			//That 00 byte must have re-appeared, and dispensed with back again, upon decrypting.  This is achieved by reverting the number to its negative original.
//			System.out.println("    original data was negative.  Swapping sign"); 
			shortDecryptedBuffer = new BigInteger(shortDecryptedBuffer).negate().toByteArray();
//			System.out.println("    decrypted data after sign-swap is " + Arrays.toString(shortDecryptedBuffer));
		}
		System.arraycopy(shortDecryptedBuffer, 0, decryptedBuffer, decryptedBuffer.length - shortDecryptedBuffer.length, shortDecryptedBuffer.length);

		currentOffset = 0;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterInputStream#read()
	 */
	@Override
	public int read ( ) throws IOException {
		if (currentOffset < 0 || currentOffset >= decryptedBuffer.length) {
			try {
				getChunk();
			} catch (be.erwinsmout.NotFoundException e) {
				return -1;
			}
		}
		return decryptedBuffer[currentOffset++] & 0x000000ff;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterInputStream#read(byte[])
	 */
	@Override
	public int read (byte[] b) throws IOException {
		return read(b, 0, b.length);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterInputStream#read(byte[], int, int)
	 */
	@Override
	public int read (byte[] b, int off, int len) throws IOException {
		for (int p = off; p < off + len; p++) {
			int ibyte = read();
			if (ibyte < 0) {
				return p == off ? -1 : p - off;
			}
			b[p] = (byte) ibyte;
		}
		return len;
	}

}
