/**
 * 
 */
package be.SIRAPRISE.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

/**
 * @author Erwin
 * 
 */
public class MyCipherOutputStream extends FilterOutputStream {

	/**
	 * 
	 */
	private int currentOffset = 0;

	/**
	 * 
	 */
	private byte[] decryptedBuffer;

	/**
	 * 
	 */
	private BigInteger encryptExponent;

	/**
	 * 
	 */
	private BigInteger modulus;

	/**
	 * Creates the RSAEncodingOutputStream
	 * 
	 * @param outputStream
	 *            The underlying output stream
	 * @param encryptExponent
	 *            The exponent using which to encrypt
	 * @param modulus
	 *            The modulus using which to encrypt
	 */
	public MyCipherOutputStream (OutputStream outputStream, BigInteger encryptExponent, BigInteger modulus) {
		super(outputStream);
		this.encryptExponent = encryptExponent;
		this.modulus = modulus;

		int blockSize = (modulus.bitLength() / 32) * 4;
		// int byteSizeUnit = 4;
		// int blockSize = byteSizeUnit;
		// BigInteger bigintegerValueOfByteSizeUnit = BigInteger.valueOf(256).pow(byteSizeUnit);
		// BigInteger maxModulusCorrespondingToBlockSize = bigintegerValueOfByteSizeUnit;
		// while (maxModulusCorrespondingToBlockSize.compareTo(modulus) < 0) {
		// blockSize += byteSizeUnit;
		// maxModulusCorrespondingToBlockSize = maxModulusCorrespondingToBlockSize.multiply(bigintegerValueOfByteSizeUnit);
		// }
		decryptedBuffer = new byte[blockSize];
	}

	/**
	 * Writes an encrypted block of data. Each block written consists of :
	 * <ol>
	 * <li>length of the original input block (4 bytes). This is the length of the block that must be allocated on decryption. The result of the decryption might be shorter than the original input if the original input starts with binary zeroes.</li>
	 * <li>length of the encrypted block (4 bytes).</li>
	 * <li>the encrypted block (n bytes).</li>
	 * <ol>
	 * 
	 * @param decryptedBufferToWrite
	 * @throws IOException
	 */
	private void writeBigIntegerBytes (byte[] decryptedBufferToWrite) throws IOException {
//		System.out.println("  Encryptor with modulus " + modulus.toString(16));
//		System.out.println("    writing block of original length " + decryptedBufferToWrite.length);
//		System.out.println("    original data is " + Arrays.toString(decryptedBufferToWrite));
		BigInteger decryptedBigInteger = new BigInteger(decryptedBufferToWrite);
		int swapSign = 1;
		if (decryptedBigInteger.signum() < 0) {
			swapSign = -1;
			decryptedBigInteger = decryptedBigInteger.negate();
		}
		byte[] encryptedLicenseBytes = decryptedBigInteger.modPow(encryptExponent, modulus).toByteArray();
//		System.out.println("    written block length is " + encryptedLicenseBytes.length);
//		System.out.println("    encrypted data is " + Arrays.toString(encryptedLicenseBytes));
		int originalInputLength = decryptedBufferToWrite.length * swapSign;
		out.write(originalInputLength >> 24);
		out.write((originalInputLength & 0x00ff0000) >> 16);
		out.write((originalInputLength & 0x0000ff00) >> 8);
		out.write((originalInputLength & 0x000000ff));
		int length = encryptedLicenseBytes.length;
		out.write(length >> 24);
		out.write((length & 0x00ff0000) >> 16);
		out.write((length & 0x0000ff00) >> 8);
		out.write((length & 0x000000ff));
		out.write(encryptedLicenseBytes);
		currentOffset = 0;
	}

	/**
	 * @throws IOException
	 */
	private void writeIncompleteBlock ( ) throws IOException {
		if (currentOffset > 0) {
			byte[] shortDecryptedBuffer = new byte[currentOffset];
			System.arraycopy(decryptedBuffer, 0, shortDecryptedBuffer, 0, currentOffset);
			writeBigIntegerBytes(shortDecryptedBuffer);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterOutputStream#close()
	 */
	@Override
	public void close ( ) throws IOException {
		writeIncompleteBlock();

		out.close();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterOutputStream#flush()
	 */
	@Override
	public void flush ( ) throws IOException {
		writeIncompleteBlock();
		out.flush();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilterOutputStream#write(int)
	 */
	@Override
	public void write (int b) throws IOException {
		decryptedBuffer[currentOffset++] = (byte) (b & 0x000000ff);
		if (currentOffset >= decryptedBuffer.length) {
			writeBigIntegerBytes(decryptedBuffer);
		}
	}
}
