/*
 * Created on 25-apr-2007
 */
package be.SIRAPRISE.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

/**
 * @author Erwin Smout
 */
public class MyDataOutputStream {

	/**
	 * Writes a string to the specified DataOutput using Java modified UTF-8 encoding in a machine-independent manner.
	 * <p>
	 * First, four bytes are written to out as if by the <code>writeInt</code> method giving the number of bytes to follow. This value is the number of bytes actually written out, not the length of the string. Following the length, each character of the string is output, in sequence, using the modified UTF-8 encoding for the character. If no exception is thrown, the counter <code>written</code> is incremented by the total number of bytes written to the output stream. This will be at least four plus the length of <code>str</code>, and at most two plus thrice the length of <code>str</code>.
	 * 
	 * @param str
	 *            a string to be written.
	 * @param out
	 *            destination to write to
	 * @return The number of bytes written out.
	 * @exception IOException
	 *                if an I/O error occurs.
	 */
	public static int writeBigUTF (String str, DataOutput out) throws IOException {
		int strlen = str.length();
		Runtime rt = Runtime.getRuntime();
		if (strlen > ((rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 3))
			throw new UTFDataFormatException();
		int utflen = 0;
		char[] charr = new char[strlen];
		int c, count = 0;

		str.getChars(0, strlen, charr, 0);

		for (int i = 0; i < strlen; i++) {
			c = charr[i];
			if ((c >= 0x0001) && (c <= 0x007F)) {
				utflen++;
			} else {
				if (c > 0x07FF) {
					utflen += 3;
				} else {
					utflen += 2;
				}
			}
		}

		byte[] bytearr = new byte[utflen + 8];
		bytearr[count++] = (byte) ((strlen >>> 24) & 0xFF);
		bytearr[count++] = (byte) ((strlen >>> 16) & 0xFF);
		bytearr[count++] = (byte) ((strlen >>> 8) & 0xFF);
		bytearr[count++] = (byte) ((strlen >>> 0) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 24) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 16) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 8) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 0) & 0xFF);
		for (int i = 0; i < strlen; i++) {
			c = charr[i];
			if ((c >= 0x0001) && (c <= 0x007F)) {
				bytearr[count++] = (byte) c;
			} else if (c > 0x07FF) {
				//				
				bytearr[count++] = (byte) (0xE0 | ((c >> 12) & 0x0F));
				bytearr[count++] = (byte) (0x80 | ((c >> 6) & 0x3F));
				bytearr[count++] = (byte) (0x80 | ((c >> 0) & 0x3F));
			} else {
				//				
				bytearr[count++] = (byte) (0xC0 | ((c >> 6) & 0x1F));
				bytearr[count++] = (byte) (0x80 | ((c >> 0) & 0x3F));
			}
		}
		out.write(bytearr);
		return utflen + 8;
	}

	/**
	 * Writes a string to the specified DataOutput using Java modified UTF-8 encoding in a machine-independent manner.
	 * <p>
	 * First, two bytes are written to out as if by the <code>writeInt</code> method giving the number of bytes to follow. This value is the number of bytes actually written out, not the length of the string. Following the length, each character of the string is output, in sequence, using the modified UTF-8 encoding for the character. If no exception is thrown, the counter <code>written</code> is incremented by the total number of bytes written to the output stream. This will be at least four plus the length of <code>str</code>, and at most two plus thrice the length of <code>str</code>.
	 * 
	 * @param str
	 *            a string to be written.
	 * @param out
	 *            destination to write to
	 * @return The number of bytes written out.
	 * @exception IOException
	 *                if an I/O error occurs.
	 */
	public static int writeSmallUTF (String str, DataOutput out) throws IOException {
		int strlen = str.length();
		if (strlen > 2 * Short.MAX_VALUE)
			throw new UTFDataFormatException();
		int utflen = 0;
		char[] charr = new char[strlen];
		int c, count = 0;

		str.getChars(0, strlen, charr, 0);

		for (int i = 0; i < strlen; i++) {
			c = charr[i];
			if ((c >= 0x0001) && (c <= 0x007F)) {
				utflen++;
			} else if (c > 0x07FF) {
				utflen += 3;
			} else {
				utflen += 2;
			}
		}

		byte[] bytearr = new byte[utflen + 4];
		// bytearr[count++] = (byte) ((strlen >>> 24) & 0xFF);
		// bytearr[count++] = (byte) ((strlen >>> 16) & 0xFF);
		bytearr[count++] = (byte) ((strlen >>> 8) & 0xFF);
		bytearr[count++] = (byte) ((strlen >>> 0) & 0xFF);
		// bytearr[count++] = (byte) ((utflen >>> 24) & 0xFF);
		// bytearr[count++] = (byte) ((utflen >>> 16) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 8) & 0xFF);
		bytearr[count++] = (byte) ((utflen >>> 0) & 0xFF);
		for (int i = 0; i < strlen; i++) {
			c = charr[i];
			if ((c >= 0x0001) && (c <= 0x007F)) {
				bytearr[count++] = (byte) c;
			} else if (c > 0x07FF) {
				bytearr[count++] = (byte) (0xE0 | ((c >> 12) & 0x0F));
				bytearr[count++] = (byte) (0x80 | ((c >> 6) & 0x3F));
				bytearr[count++] = (byte) (0x80 | ((c >> 0) & 0x3F));
			} else {
				bytearr[count++] = (byte) (0xC0 | ((c >> 6) & 0x1F));
				bytearr[count++] = (byte) (0x80 | ((c >> 0) & 0x3F));
			}
		}
		out.write(bytearr);

		return utflen + 4;
	}
}
