/**
 * 
 */
package be.SIRAPRISE.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/**
 * @author Erwin
 * @param <E>
 * 
 */
public final class MyListSet<E> implements Set<E> {

	/**
	 * 
	 */
	private LinkedList<E> elements;

	/**
	 * 
	 */
	private int hashCode;

	/**
	 * 
	 */
	private boolean hashCodeObsolete;

	/**
	 * Creates the MyReadOnlySet
	 * 
	 * @param contents
	 */
	public MyListSet (Collection<E> contents) {
		this(new HashSet<E>(contents));
	}

	/**
	 * Creates the MyReadOnlyEntrySet
	 * 
	 * @param entrySet
	 */
	public MyListSet (Set<E> entrySet) {
		this.elements = new LinkedList<E>(entrySet);
		hashCode = entrySet.hashCode();
		hashCodeObsolete = false;
	}

	/**
	 * @return
	 */
	private int computeHashCode ( ) {
		return new HashSet<E>(elements).hashCode();
	}

	/**
	 * 
	 */
	void obsoleteHashCode ( ) {
		this.hashCodeObsolete = true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#add(java.lang.Object)
	 */
	@Override
	public boolean add (E e) {
		boolean added = !contains(e);
		if (added) {
			elements.addLast(e);
		}
		hashCodeObsolete |= added;
		return added;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#addAll(java.util.Collection)
	 */
	@Override
	public boolean addAll (Collection<? extends E> c) {
		boolean changed = false;
		for (E e : c) {
			changed |= add(e);
		}
		hashCodeObsolete |= changed;
		return changed;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#clear()
	 */
	@Override
	public void clear ( ) {
		if (elements.size() > 0) {
			elements.clear();
			obsoleteHashCode();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#contains(java.lang.Object)
	 */
	@Override
	public boolean contains (Object o) {
		return elements.contains(o);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#containsAll(java.util.Collection)
	 */
	@Override
	public boolean containsAll (Collection<?> c) {
		return elements.containsAll(c);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals (Object obj) {
		return obj instanceof Set && ((Set<?>) obj).size() == elements.size() && ((Set<?>) obj).containsAll(elements);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode ( ) {
		return hashCodeObsolete ? (hashCode = computeHashCode()) : hashCode;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#isEmpty()
	 */
	@Override
	public boolean isEmpty ( ) {
		return elements.isEmpty();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#iterator()
	 */
	@Override
	public Iterator<E> iterator ( ) {
		return new MyListSetIterator<E>(this, elements.iterator());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#remove(java.lang.Object)
	 */
	@Override
	public boolean remove (Object o) {
		return (hashCodeObsolete = elements.remove(o));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#removeAll(java.util.Collection)
	 */
	@Override
	public boolean removeAll (Collection<?> c) {
		return (hashCodeObsolete = elements.removeAll(c));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#retainAll(java.util.Collection)
	 */
	@Override
	public boolean retainAll (Collection<?> c) {
		return (hashCodeObsolete = elements.retainAll(c));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#size()
	 */
	@Override
	public int size ( ) {
		return elements.size();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#toArray()
	 */
	@Override
	public Object[] toArray ( ) {
		return elements.toArray();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Set#toArray(T[])
	 */
	@Override
	public <T> T[] toArray (T[] a) {
		return elements.toArray(a);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return elements.toString();
	}
}
