/**
 * 
 */
package be.SIRAPRISE.util;

import java.util.Iterator;

/**
 * @author Erwin
 * @param <E>
 * 
 */
public final class MyListSetIterator<E> implements Iterator<E> {

	/**
	 * 
	 */
	private MyListSet<E> myListSet;

	/**
	 * 
	 */
	private Iterator<E> underlyingIterator;

	/**
	 * Creates the MyListSetIterator
	 * 
	 * @param myListSet
	 * @param iterator
	 */
	public MyListSetIterator (MyListSet<E> myListSet, Iterator<E> iterator) {
		this.underlyingIterator = iterator;
		this.myListSet = myListSet;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Iterator#hasNext()
	 */
	@Override
	public boolean hasNext ( ) {
		return underlyingIterator.hasNext();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Iterator#next()
	 */
	@Override
	public E next ( ) {
		return underlyingIterator.next();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Iterator#remove()
	 */
	@Override
	public void remove ( ) {
		underlyingIterator.remove();
		myListSet.obsoleteHashCode();
	}

}
