/**
 * 
 */
package be.SIRAPRISE.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * @author Erwin
 * @param <V>
 * @param <K>
 * 
 */
public class MyReadOnlyMap<K, V> implements Map<K, V> {

	/**
	 * 
	 */
	private Map<K, V> underLyingMap;

	/**
	 * Creates the MyReadOnlyMap
	 * 
	 * @param underLyingMap
	 */
	public MyReadOnlyMap (Map<K, V> underLyingMap) {
		this.underLyingMap = underLyingMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#clear()
	 */
	@Override
	public void clear ( ) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	@Override
	public boolean containsKey (Object key) {
		return underLyingMap.containsKey(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	@Override
	public boolean containsValue (Object value) {
		return underLyingMap.containsValue(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#entrySet()
	 */
	@Override
	public Set<java.util.Map.Entry<K, V>> entrySet ( ) {
		return new MyReadOnlySet<java.util.Map.Entry<K, V>>(underLyingMap.entrySet());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals (Object obj) {
		return underLyingMap.equals(obj);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#get(java.lang.Object)
	 */
	@Override
	public V get (Object key) {
		return underLyingMap.get(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode ( ) {
		return underLyingMap.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#isEmpty()
	 */
	@Override
	public boolean isEmpty ( ) {
		return underLyingMap.isEmpty();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#keySet()
	 */
	@Override
	public Set<K> keySet ( ) {
		return new MyReadOnlySet<K>(underLyingMap.keySet());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	@Override
	public V put (K key, V value) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	@Override
	public void putAll (Map<? extends K, ? extends V> m) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	@Override
	public V remove (Object key) {
		throw new UnsupportedOperationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#size()
	 */
	@Override
	public int size ( ) {
		return underLyingMap.size();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ( ) {
		return underLyingMap.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.util.Map#values()
	 */
	@Override
	public Collection<V> values ( ) {
		return new MyReadOnlyCollection<V>(underLyingMap.values());
	}

}
