/*
 * Created on 29-apr-2008
 */
package be.SIRAPRISE.util;

/**
 * A NameValuePair contains the separated Name and value components from a textual expression of the form NAME(value).
 * 
 * @author Erwin Smout
 */
public class NameValuePair {

	/**
	 * The name
	 */
	private String name;

	/**
	 * The value
	 */
	private String value;

	/**
	 * @param name
	 * @param value
	 */
	public NameValuePair (String name, String value) {
		this.name = name;
		this.value = value;
	}

	/**
	 * Gets The name
	 * 
	 * @return the name.
	 */
	public String getName ( ) {
		return name.toUpperCase();
	}

	/**
	 * Gets the value
	 * 
	 * @return the value.
	 */
	public String getValue ( ) {
		return value;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return "Name : " + name + " Value : " + value; //$NON-NLS-1$//$NON-NLS-2$
	}

}
