/*
 * Created on 29-apr-2008
 */
package be.SIRAPRISE.util;

/**
 * @author Erwin Smout
 */
public class NameValueResult {

	/**
	 * The last parsed position in the input string
	 */
	private int lastParsedPos;

	/**
	 * The NameValuePair that represents the actual content of the NAME(VALUE) string
	 */
	private NameValuePair nameValuePair;

	/**
	 * The first parsed position in the input string
	 */
	private int startPos;

	/**
	 * Creates the NameValueResult
	 * 
	 * @param startPos
	 *            The first parsed position in the input string
	 * @param lastParsedPos
	 *            The last parsed position in the input string
	 * @param nameValuePair
	 *            The NameValuePair that represents the actual content of the NAME(VALUE) string
	 */
	public NameValueResult (int startPos, int lastParsedPos, NameValuePair nameValuePair) {
		this.startPos = startPos;
		this.lastParsedPos = lastParsedPos;
		this.nameValuePair = nameValuePair;
	}

	/**
	 * Gets The NameValuePair that represents the actual content of the NAME(VALUE) string
	 * 
	 * @return The NameValuePair that represents the actual content of the NAME(VALUE) string
	 */
	public NameValuePair getNameValuePair ( ) {
		return nameValuePair;
	}

	/**
	 * Gets The last parsed position in the input string
	 * 
	 * @return The last parsed position in the input string
	 */
	public int getNextParsePos ( ) {
		return lastParsedPos + 1;
	}

	/**
	 * Gets The first parsed position in the input string
	 * 
	 * @return The first parsed position in the input string
	 */
	public int getStartPos ( ) {
		return startPos;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return nameValuePair.toString();
	}
}
