/*
 * Created on 27-jul-2008
 */
package be.SIRAPRISE.util;

import java.io.EOFException;
import java.text.MessageFormat;

/**
 * @author Erwin Smout
 */
public class PrematureEOFException extends EOFException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3895080822627834911L;

	/**
	 * @param totalBytesRead
	 * @param expectedByteCount
	 */
	public PrematureEOFException (int totalBytesRead, int expectedByteCount) {
		super(MessageFormat.format("EOF encountered after reading {0} bytes, expecting {1} bytes.", new Object[] { new Integer(totalBytesRead), new Integer(expectedByteCount) })); //$NON-NLS-1$
	}
}
