/**
 * 
 */
package be.SIRAPRISE.util;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.Tuple;

/**
 * @author Erwin
 * 
 */
public class RelationValueSelectorFactory {

	/**
	 * Gets A Set holding the individual names that appear in the comma-separated list
	 * 
	 * @param in
	 *            A comma-separated list of names
	 * @return A Set holding the individual names that appear in the comma-separated list
	 */
	public static final Set<String> getNames (String in) {
		Set<String> set = new HashSet<String>();

		String[] names = in.split(","); //$NON-NLS-1$
		for (String name : names) {
			String trimmedName = name.trim();
			if (trimmedName.length() > 0) {
				set.add(trimmedName);
			}
		}

		return set;
	}

	/**
	 * Gets A Set holding the individual names that appear in the comma-separated list
	 * 
	 * @param in
	 *            A comma-separated list of names
	 * @return A Set holding the individual names that appear in the comma-separated list
	 */
	public static final LinkedList<String> getNamesInEntryOrder (String in) {
		LinkedList<String> set = new LinkedList<String>();

		String[] names = in.split(","); //$NON-NLS-1$
		for (String name : names) {
			String trimmedName = name.trim();
			if (trimmedName.length() > 0) {
				set.add(trimmedName);
			}
		}

		return set;
	}

	/**
	 * Gets A Set holding the individual names that appear in the comma-separated list
	 * 
	 * @param in
	 *            A comma-separated list of names
	 * @return A Set holding the individual names that appear in the comma-separated list
	 */
	public static final LinkedHashSet<String> getNamesInEntryOrderWithoutDuplicates (String in) {
		LinkedHashSet<String> set = new LinkedHashSet<String>();

		String[] names = in.split(","); //$NON-NLS-1$
		for (String name : names) {
			String trimmedName = name.trim();
			if (trimmedName.length() > 0) {
				set.add(trimmedName);
			}
		}

		return set;
	}

	/**
	 * @param x
	 * @param attributeName
	 * @return A commalist holding the values of the named attribute in the given relation
	 */
	public static final String getRelationAttributeValueCommalist (AbstractRelation x, String attributeName) {
		StringBuilder result = new StringBuilder(40 * x.size());
		String separator = ""; //$NON-NLS-1$
		for (Tuple tuple : x) {
			result.append(separator).append(tuple.value(attributeName));
			separator = ","; //$NON-NLS-1$
		}
		return result.toString();
	}

	/**
	 * @param names
	 * @param attributeName
	 * @param typeName
	 * @return A relation value selector that selects a relation of degree one, with the given attribute and type name, and with tuples holding the values in the given set
	 */
	public static final String getRelationValueSelector (Set<String> names, String attributeName, String typeName) {
		StringBuilder bResult = new StringBuilder(30 * names.size());
		for (String name : names) {
			bResult.append("TUPLE(" + attributeName + "(" + name + "))"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
		}
		return "RELATION(HEADING(" + attributeName + "(" + typeName + "))BODY(" + bResult + "))"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

}
