/*
 * Created on 12-sep-2007
 */
package be.SIRAPRISE.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Iterator;

/**
 * @author Erwin Smout
 */
public class SiraPriseConjunctFileNameFilterSet implements FilenameFilter {

	/**
	 * The suffix for which is to be filtered
	 */
	private Collection<FilenameFilter> filters;

	/**
	 * Creates the suffixfilter
	 * 
	 * @param filters
	 *            The suffix for which is to be filtered
	 */
	public SiraPriseConjunctFileNameFilterSet (Collection<FilenameFilter> filters) {
		this.filters = filters;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public boolean accept (File dir, String name) {
		boolean a = true;
		Iterator<FilenameFilter> i_filters = filters.iterator();
		while (i_filters.hasNext() && a) {
			a &= i_filters.next().accept(dir, name);
		}
		return a;
	}
}
