/*
 * Created on 12-sep-2007
 */
package be.SIRAPRISE.util;

import java.io.File;
import java.io.FilenameFilter;

/**
 * @author Erwin Smout
 */
public class SiraPrisePrefixFilter implements FilenameFilter {

	/**
	 * The prefix for which is to be filtered
	 */
	private String prefix;

	/**
	 * Creates the prefixfilter
	 * 
	 * @param prefix
	 *            The prefix for which is to be filtered
	 */
	public SiraPrisePrefixFilter (String prefix) {
		this.prefix = prefix;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public boolean accept (File dir, String name) {
		int l = name.length();
		return l >= prefix.length() && name.substring(0, prefix.length()).equalsIgnoreCase(prefix);
	}
}
