/*
 * Created on 12-sep-2007
 */
package be.SIRAPRISE.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

/**
 * @author Erwin Smout
 */
public class SiraPriseRegexFilter implements FilenameFilter {

	/**
	 * The regular expression to which filenames are to match
	 */
	private Pattern pattern;

	/**
	 * Creates the regexfilter
	 * 
	 * @param regex
	 *            The regular expression to which filenames are to match
	 */
	public SiraPriseRegexFilter (String regex) {
		this.pattern = Pattern.compile(regex);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public boolean accept (File dir, String name) {
		return pattern.matcher(name).matches();
	}
}
