/*
 * Created on 12-sep-2007
 */
package be.SIRAPRISE.util;

import java.io.File;
import java.io.FilenameFilter;

/**
 * @author Erwin Smout
 */
public class SiraPriseSuffixFilter implements FilenameFilter {

	/**
	 * The suffix for which is to be filtered
	 */
	private String suffix;

	/**
	 * Creates the suffixfilter
	 * 
	 * @param suffix
	 *            The suffix for which is to be filtered
	 */
	public SiraPriseSuffixFilter (String suffix) {
		this.suffix = suffix;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public boolean accept (File dir, String name) {
		int l = name.length();
		return l >= suffix.length() && name.substring(l - suffix.length(), l).equalsIgnoreCase(suffix);
	}
}
