/*
 * Created on 30-aug-2008
 */
package be.SIRAPRISE.util;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import be.SIRAPRISE.client.Signer;
import be.erwinsmout.NotFoundException;

/**
 * @author Erwin Smout
 */
public class UserPrivateKeyProvider implements Signer {

	/**
	 * Comment for <code>jks</code>
	 */
	private KeyStore keyStore;

	/**
	 * Comment for <code>user</code>
	 */
	private String user;

	/**
	 * @param user
	 * @throws NotFoundException
	 */
	public UserPrivateKeyProvider (String user) throws NotFoundException {
		this.user = user;
		try {
			// Get the keystore
			keyStore = MyKeyStore.getKeyStore(user);
		} catch (KeyStoreException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		} catch (NoSuchAlgorithmException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		} catch (CertificateException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		} catch (IOException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		}
	}

	/**
	 * Gets The private Key
	 * 
	 * @param algorithm
	 * @return The private Key
	 * @throws NotFoundException
	 */
	private PrivateKey getPrivateKey (String algorithm) throws NotFoundException {
		try {
			// Get the private Key from the keystore. This is the key that is stored in the keystore for the alias that is equal to the clientID, suffixed with the algorithm name
			return (PrivateKey) keyStore.getKey(user + algorithm, user.toCharArray());
		} catch (KeyStoreException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		} catch (NoSuchAlgorithmException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		} catch (UnrecoverableKeyException e) {
			throw new NotFoundException(e.getClass().getName() + e.getMessage() != null ? e.getMessage() : ""); //$NON-NLS-1$
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.security.PrivateKeyProvider#sign(java.security.Signature, byte[])
	 */
	public byte[] sign (Signature signature, byte[] signMessage) throws InvalidKeyException, SignatureException, NotFoundException {
		signature.initSign(getPrivateKey(signature.getAlgorithm()));
		signature.update(signMessage);
		return signature.sign();
	}
}
